<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Booking extends Model 
{

    protected $table = 'bookings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'property_id', 'reservation_id', 'invoice_id', 'remain', 'pay_type', 'total_price');

    public function points()
    {
        return $this->hasMany('App\Models\Point');
    }

    public function property()
    {
        return $this->belongsTo('App\Models\Property');
    }

    public function invoice()
    {
        return $this->belongsTo('App\Models\Invoices');
    }

    public function reservation()
    {
        return $this->belongsTo('App\Models\Reservation');
    }

}